import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../../Utilities/CustomStyleAttribute/dpr";

const { height, width } = Dimensions.get("window");

export const OrderDetailsStyle = StyleSheet.create({
	container: {
		flex: 1,
		backgroundColor: "#fff",
	},
	calculationMargin: { marginBottom: 15 },
	idNum: {
		textAlign: "center",
		fontFamily: "DMSans_500Medium",
		fontSize: dpr(16),
		color: "#2C2C2C",
		marginTop: dpr(30),
		marginBottom: dpr(9),
	},
	invoiceId: {
		marginTop: dpr(5),
		textAlign: "center",
		fontFamily: "DMSans_700Bold",
		fontSize: dpr(24),
		color: "#2C2C2C",
	},
	statusCont: {
		flexDirection: "row",
		justifyContent: "center",
		marginTop: dpr(14),
		marginBottom: dpr(30),
	},
	status: {
		flexDirection: "row",
		justifyContent: "center",
		alignItems: "center",
		backgroundColor: "#FEF8E7",
		borderRadius: 4,
		paddingHorizontal: dpr(16),
		paddingVertical: dpr(6),
	},
	statusText: {
		marginLeft: dpr(6),
		fontFamily: "Roboto_500Medium",
		fontSize: dpr(16),
		color: "#DEA512",
	},
	infoCont: {
		paddingHorizontal: dpr(20),
		marginTop: dpr(10),
	},
	deliveryCont: {
		backgroundColor: "#F4F4F4",
		flexDirection: "row",
		paddingVertical: dpr(20),
		borderRadius: 6,
	},
	invoiceCont: {
		backgroundColor: "#fff",
		marginBottom: dpr(15),
		borderWidth: 1,
		borderColor: "#DFDFDF",
	},
	deliverySubCont: {
		paddingHorizontal: dpr(15),
		width: (width - dpr(20) * 2) / 2,
	},
	borderStyle: {
		borderLeftWidth: 1,
		borderColor: "#B1B1B1",
	},
	deliveryText1: {
		fontFamily: "DMSans_500Medium",
		fontSize: dpr(15),
		color: "#2C2C2C",
		textAlign: 'left'
	},
	deliveryText2: {
		fontFamily: "Roboto_500Medium",
		fontSize: dpr(13),
		color: "#929292",
		marginTop: dpr(5),
		textAlign: 'left'
	},
	shoppingAddressCont: {
		flexDirection: "row",
		gap: dpr(20),
	},
	shoppingTitle: {
		marginTop: dpr(20),
		fontFamily: "DMSans_500Medium",
		fontSize: dpr(16),
		color: "#2C2C2C",
	},
	shoppingTextCont: {
		flexDirection: "row",
		gap: dpr(20),
		marginTop: dpr(13),
	},
	shoppingTextWidth: {
		width: (width - dpr(20) * 2) / 2,
	},
	shoppingText: {
		fontFamily: "Roboto_500Medium",
		fontSize: dpr(14),
		lineHeight: dpr(22),
		color: "#898989",
		marginBottom: dpr(5),
		textAlign: 'left'
	},
	orderProductsCont: {
		marginTop: dpr(20),
		marginBottom: dpr(10),
		borderWidth: 1,
		borderColor: "#DFDFDF",
		borderRadius: 6,
	},
	orderProductTitle: {
		fontFamily: "DMSans_700Bold",
		fontSize: dpr(15),
		color: "#2C2C2C",
		marginHorizontal: dpr(15),
		marginVertical: dpr(15),
	},
	singleProductCont: {
		flexDirection: "row",
		justifyContent: "space-between",
		paddingHorizontal: dpr(15),
		paddingTop: dpr(12),
		paddingBottom: dpr(12),
		borderBottomWidth: 1,
		borderBottomColor: "#DFDFDF",
	},
	lastProductCont: (index, length) => ({
		borderBottomWidth: index === length - 1 ? 0 : 1,
		paddingBottom: index === length - 1 ? dpr(12) : dpr(12),
		marginBottom: index === length - 1 ? 0 : dpr(12),
	}),
	name: {
		fontFamily: "DMSans_500Medium",
		fontSize: dpr(13),
		lineHeight: dpr(17),
		color: "#2C2C2C",
		marginBottom: dpr(7),
		textAlign: 'left'
	},
	quantity: {
		fontFamily: "Roboto_500Medium",
		fontSize: dpr(11),
		color: "#868686",
		textAlign: "right",
	},
	items: {
		flexDirection: "row",
	},
	hrLine: {
		width: width - dpr(20) * 2 - 2,
	},
	vrLine: {
		borderLeftWidth: 1,
		marginHorizontal: dpr(12),
		borderColor: "#B1B1B1",
	},
	subTotalCont: {
		flexDirection: "row",
		justifyContent: "space-between",
		marginTop: dpr(15),
		borderBottomWidth: 1,
		borderColor: "#DFDFDF",
		paddingBottom: dpr(15),
	},
	subText: {
		fontFamily: "DMSans_500Medium",
		fontSize: dpr(16),
		color: "#2C2C2C",
	},
	grandTotal: {
		backgroundColor: "#2C2C2C",
		borderRadius: 6,
		paddingHorizontal: dpr(12),
		paddingVertical: dpr(15),
	},
	taxCont: {
		borderBottomWidth: 0,
		paddingBottom: 0,
	},
	deliverySubContainer: {
        borderLeftWidth: 1,
        borderColor: "#B1B1B1"
    },
	mt_15: {
		marginTop: dpr(15),
	},
});
